precision mediump float;

uniform sampler2D texture_albedo_normal_0;
uniform sampler2D texture_albedo_normal_1;
uniform sampler2D texture_light_buffer;
uniform float uniform_brightness;
uniform float uniform_albedo_only;

varying vec2 v_uv;

void main()
{   
    vec4 diffuse  = texture2D(texture_light_buffer,  v_uv);    
    vec4 albedo   = texture2D(texture_albedo_normal_0, v_uv);
    vec4 normal   = texture2D(texture_albedo_normal_1, v_uv);
    
	if ( uniform_albedo_only > 0.5 )
	{
		gl_FragColor = vec4(albedo.xyz,1.0);
	}
	else
	{
		diffuse.xyz = mix( diffuse.xyz,vec3(1.0,1.0,1.0),normal.w);	
		gl_FragColor  = vec4(((albedo.xyz * diffuse.xyz)*2.0)*uniform_brightness,1.0);    
	}
}
